clear all
close all
clc
set1=xlsread("circlehollow3clamped_0.2.xlsx");
set2=xlsread("circlehollow4clamped_0.2.xlsx");
set3=xlsread("circlehollow5clamped_0.2.xlsx");
%% transmission loss
TL1=set1(3:end,7);
TL2=set2(3:end,7);
TL3=set3(3:end,7);
freq=set2(3:end,1);
subplot(1,2,1)
plot(freq(1:end-1),TL1)
hold on
grid on
plot(freq,TL2,'color','cyan')
plot(freq,TL3)
title('circlehollow clamped comparison')
xlabel('Frequency (Hz)')
ylabel('Transmission Loss (dB)')
pbaspect([2 1 1])
legend('3','4','5');
%% transmissibility
r1=set1(3:end,6);
r2=set2(3:end,6);
r3=set3(3:end,6);

subplot(1,2,2)
plot(freq(1:end-1),r1)
hold on
grid on
plot(freq,r2,'color','magenta')
plot(freq,r3)
title('circlehollow clamped comparison')
xlabel('Frequency (Hz)')
ylabel('Transmismissibility')
legend('3','4','5');
pbaspect([2 1 1])
% %% Mobility
% %here we will consider only with the aplification of 0.2 which is good
% % mo_in1=set1(3:end,6);
% mo_in2=set2(3:end,14);
% % mo_in3=set3(3:end,6);
% % mo_out1=set1(3:end,6);
% mo_out2=set2(3:end,15);
% % mo_out3=set3(3:end,6);
% subplot(2,2,3)
% plot(freq,mo_in2,'color','[0.9290 0.6940 0.1250]','LineWidth',1.5)
% hold on
% grid on
% plot(freq,mo_out2,'color','[0.3010 0.7450 0.9330]','LineWidth',1.5)
% title('circlehollow3free, Mobility')
% xlabel('Frequency (Hz)')
% ylabel('Mobility')
% legend('in','out');
% pbaspect([2 1 1])
% %% compliance
% co_in2=set2(3:end,12);
% co_out2=set2(3:end,13);
% subplot(2,2,4)
% plot(freq,co_in2,'color','[0.9290 0.6940 0.1250]','LineWidth',1.5)
% hold on
% grid on
% plot(freq,co_out2,'color','[0.3010 0.7450 0.9330]','LineWidth',1.5)
% title('circlehollow3free, Complience')
% xlabel('Frequency (Hz)')
% ylabel('Complience')
% legend('in','out');
% pbaspect([2 1 1]);
% %% Accelerance
% Ac_in2=set2(3:end,16);
% Ac_out2=set2(3:end,17);
% figure(5)
% plot(freq,Ac_in2,'color','[0.9290 0.6940 0.1250]','LineWidth',1.5)
% hold on
% grid on
% plot(freq,Ac_out2,'color','[0.3010 0.7450 0.9330]','LineWidth',1.5)
% title('circlehollow3free, Accelerance')
% xlabel('Frequency (Hz)')
% ylabel('Accelerance')
% legend('in','out');
% pbaspect([2 1 1]);